<?php
namespace boru\boruaiweb\Providers\BoruAI;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Contracts\SettingsInterface;

use boru\boruaiweb\Providers\BoruAI\Auth\BoruAiSessionAuthProvider;
use boru\boruaiweb\Providers\BoruAI\History\BoruAiHistoryRepository;
use boru\boruaiweb\Providers\BoruAI\References\BoruAiReferenceRepository;

use boru\boruaiweb\Providers\BoruAI\Chat\BoruAiChatService;
use boru\boruaiweb\Providers\BoruAI\Responses\BoruAiResponseRepository;
use boru\boruaiweb\Providers\BoruAI\Tools\BoruAiToolCatalog;

class BoruAiProviderFactory
{
    /**
     * Wire BoruAI-backed providers onto the given WebConfig.
     * @param WebConfig $config
     * @param SettingsInterface|null $settings If null, uses $config (WebConfig implements SettingsInterface)
     * @return WebConfig
     */
    public static function wire(WebConfig $config, SettingsInterface $settings = null)
    {
        if ($settings === null) $settings = $config;
        
        // HISTORY + REFERENCES
        $config->withHistory(new BoruAiHistoryRepository($settings));
        $config->withReferences(new BoruAiReferenceRepository($settings));

        // CHAT
        $config->withChat(new BoruAiChatService($settings));

        //RESPONSES
        $config->withResponses(new BoruAiResponseRepository($settings));

        // TOOLS
        $config->withTools(new BoruAiToolCatalog($settings));

        return $config;
    }
}
