<?php
namespace boru\boruaiweb\Providers\BoruAI\Responses;

use boru\boruaiweb\Contracts\ResponseRepositoryInterface;
use boru\boruaiweb\Contracts\SettingsInterface;

class BoruAiResponseRepository implements ResponseRepositoryInterface
{
    /** @var SettingsInterface|null */
    private $settings;

    /** @var string */
    private $settingsPrefix;

    /**
     * @param SettingsInterface|null $settings
     * @param string $settingsPrefix
     */
    public function __construct(SettingsInterface $settings = null, $settingsPrefix = 'boruaiweb.boruai.chat.')
    {
        $this->settings = $settings;
        $this->settingsPrefix = (string)$settingsPrefix;
    }

    private function get($key, $default = null)
    {
        if (!$this->settings) return $default;
        return $this->settings->get($this->settingsPrefix . $key, $default);
    }

    private function getBool($key, $default = false)
    {
        $v = $this->get($key, $default);
        return (bool)$v;
    }
    
    /**
     * @param int|string $id
     * @return array|null
     */
    public function find($id)
    {
        if (!class_exists('\\boru\\boruai\\Models\\Response')) {
            throw new \Exception("BoruAI library is not available");
        }

        $response = \boru\boruai\Models\Response::fromId($id);
        if (!$response) return null;

        $row = array(
            'id' => method_exists($response, 'id') ? $response->id() : $id,
            'status' => method_exists($response, 'status') ? $response->status() : null,
            'output' => method_exists($response, 'getResult') ? $response->getResult() : '',
        );

        return $row;
    }
}
