<?php
namespace boru\boruaiweb\Providers\BoruAI\Tools;

use boru\boruaiweb\Contracts\SettingsInterface;
use boru\boruaiweb\Contracts\ToolCatalogInterface;

class BoruAiToolCatalog implements ToolCatalogInterface
{
    /** @var array */
    private $enabled;
    /** @var array */
    private $forced;

    /** @var SettingsInterface|null */
    private $settings;

    /** @var string */
    private $settingsPrefix;

    /**
     * @param SettingsInterface|null $settings
     * @param string $settingsPrefix
     */
    public function __construct(SettingsInterface $settings = null, $settingsPrefix = 'boruaiweb.boruai.tools.')
    {
        $this->settings = $settings;
        $this->settingsPrefix = (string)$settingsPrefix;
        $this->enabled = (array)$this->get('enabled', array());
        $this->forced  = (array)$this->get('forced', array());
    }

    private function get($key, $default = null)
    {
        if (!$this->settings) return $default;
        return $this->settings->get($this->settingsPrefix . $key, $default);
    }

    private function getBool($key, $default = false)
    {
        $v = $this->get($key, $default);
        return (bool)$v;
    }

    /**
     * Return tool objects (or empty array).
     * @return array
     */
    public function listTools()
    {
        if (!class_exists('\\boru\\boruai\\BoruAI') || !method_exists('\\boru\\boruai\\BoruAI', 'loadTool')) {
            return array();
        }

        $out = array();

        // forced always included
        foreach ($this->forced as $name) {
            $tool = $this->load($name);
            if ($tool) $out[$this->toolKey($tool, $name)] = $tool;
        }

        // enabled included if not already present
        foreach ($this->enabled as $name) {
            $tool = $this->load($name);
            if ($tool) {
                $k = $this->toolKey($tool, $name);
                if (!isset($out[$k])) $out[$k] = $tool;
            }
        }

        return array_values($out);
    }

    /**
     * @param string $name
     * @return object|null
     */
    private function load($name)
    {
        $name = (string)$name;
        if ($name === '') return null;

        $tool = \boru\boruai\BoruAI::loadTool($name);
        if (!is_object($tool)) return null;

        // mimic legacy guard: must be usable for responses
        if (method_exists($tool, 'forResponse')) return $tool;

        return $tool; // still allow if BoruAI accepts it
    }

    /**
     * @param object $tool
     * @param string $fallback
     * @return string
     */
    private function toolKey($tool, $fallback)
    {
        if (method_exists($tool, 'name')) return (string)$tool->name();
        return (string)$fallback;
    }
}
