<?php
namespace boru\boruaiweb\Publishing;

class Publisher
{
    /**
     * Recursively copy directory contents.
     *
     * @param string $source
     * @param string $dest
     * @param bool $overwrite
     * @return void
     */
    public static function copyDir($source, $dest, $overwrite = false)
    {
        if (!is_dir($source)) {
            throw new \RuntimeException("Source directory not found: " . $source);
        }

        if (!is_dir($dest)) {
            if (!mkdir($dest, 0777, true) && !is_dir($dest)) {
                throw new \RuntimeException("Failed to create directory: " . $dest);
            }
        }

        $items = scandir($source);
        if ($items === false) return;

        foreach ($items as $item) {
            if ($item === '.' || $item === '..') continue;

            $srcPath  = $source . DIRECTORY_SEPARATOR . $item;
            $destPath = $dest . DIRECTORY_SEPARATOR . $item;

            if (is_dir($srcPath)) {
                self::copyDir($srcPath, $destPath, $overwrite);
            } else {
                if (file_exists($destPath) && !$overwrite) {
                    continue;
                }
                if (!copy($srcPath, $destPath)) {
                    throw new \RuntimeException("Failed to copy file: {$srcPath} → {$destPath}");
                }
            }
        }
    }
}
