<?php
namespace boru\boruaiweb\Rendering;

class PhpTemplateRenderer
{
    /** @var string|null */
    private $userTemplateDir;
    /** @var string */
    private $packageTemplateDir;

    /**
     * @param string|null $userTemplateDir
     * @param string $packageTemplateDir
     */
    public function __construct($userTemplateDir, $packageTemplateDir)
    {
        $this->userTemplateDir = $userTemplateDir ? rtrim($userTemplateDir, DIRECTORY_SEPARATOR) : null;
        $this->packageTemplateDir = rtrim($packageTemplateDir, DIRECTORY_SEPARATOR);
    }

    /**
     * @param string $templateName e.g. "webui.php"
     * @param array $vars
     * @return string
     */
    public function render($templateName, array $vars)
    {
        $path = $this->resolve($templateName);
        if (!$path) {
            throw new \RuntimeException("Template not found: " . $templateName);
        }

        // isolate scope
        ob_start();
        // Provide $vm always, and optionally extracted keys for convenience.
        $vm = $vars;
        extract($vars, EXTR_SKIP);
        require $path;
        return (string)ob_get_clean();
    }

    /**
     * @param string $templateName
     * @return string|null
     */
    public function resolve($templateName)
    {
        $templateName = ltrim((string)$templateName, '/\\');

        if ($this->userTemplateDir) {
            $userPath = $this->userTemplateDir . DIRECTORY_SEPARATOR . $templateName;
            if (is_file($userPath)) return $userPath;
        }

        $pkgPath = $this->packageTemplateDir . DIRECTORY_SEPARATOR . $templateName;
        if (is_file($pkgPath)) return $pkgPath;

        return null;
    }
}
