<?php
namespace boru\boruaiweb\Settings;

use boru\boruaiweb\Contracts\SettingsInterface;

class ArraySettings implements SettingsInterface
{
    /**
     * @var array
     */
    protected $settings = [];

    /**
     * Constructor.
     *
     * @param array $initialSettings
     */
    public function __construct(array $initialSettings = [])
    {
        $this->settings = $initialSettings;
    }

    /**
     * Get a setting by key.
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get($key, $default = null)
    {
        return array_key_exists($key, $this->settings) ? $this->settings[$key] : $default;
    }

    /**
     * Set a setting by key.
     *
     * @param string $key
     * @param mixed $value
     * @return $this
     */
    public function set($key, $value)
    {
        $this->settings[$key] = $value;
        return $this;
    }

    /** @return array */
    public function all()
    {
        return $this->settings;
    }
}