<?php
namespace boru\boruaiweb\Support;

use boru\boruaiweb\WebConfig;

class PathResolver {
    private $config;

    public function __construct(WebConfig $config) {
        $this->config = $config;
    }

    public function resolveTemplate($name) {
        $name = ltrim($name, '/\\');
        $user = $this->config->userTemplateDir . DIRECTORY_SEPARATOR . $name;
        if (is_file($user)) return $user;

        $pkg = rtrim($this->config->packageResourceDir, '/\\') . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . $name;
        if (is_file($pkg)) return $pkg;

        return null;
    }

    public function resolveAssetFile($relative) {
        $relative = ltrim($relative, '/\\');
        $user = $this->config->userAssetDir . DIRECTORY_SEPARATOR . $relative;
        if (is_file($user)) return $user;

        $pkg = rtrim($this->config->packageResourceDir, '/\\') . DIRECTORY_SEPARATOR . 'assets' . DIRECTORY_SEPARATOR . $relative;
        if (is_file($pkg)) return $pkg;

        return null;
    }

    public function assetUrl($relative) {
        $relative = str_replace('\\', '/', ltrim($relative, '/\\'));
        return rtrim($this->config->assetUrlPrefix, '/') . '/' . $relative;
    }
}
