<?php
namespace boru\boruaiweb\Support;

use boru\boruaiweb\WebConfig;

class Publisher {
    private $cfg;

    public function __construct(WebConfig $cfg) { $this->cfg = $cfg; }

    public function publishDefaults($overwrite=false) {
        $srcTemplates = rtrim($this->cfg->packageResourceDir, '/\\') . DIRECTORY_SEPARATOR . 'templates';
        $srcAssets = rtrim($this->cfg->packageResourceDir, '/\\') . DIRECTORY_SEPARATOR . 'assets';

        $this->copyDir($srcTemplates, $this->cfg->userTemplateDir, $overwrite);
        $this->copyDir($srcAssets, $this->cfg->userAssetDir, $overwrite);
    }

    private function copyDir($src, $dst, $overwrite) {
        if (!is_dir($src)) return;
        if (!is_dir($dst)) @mkdir($dst, 0777, true);

        $items = scandir($src);
        if (!$items) return;

        foreach ($items as $item) {
            if ($item === '.' || $item === '..') continue;
            $from = $src . DIRECTORY_SEPARATOR . $item;
            $to = $dst . DIRECTORY_SEPARATOR . $item;
            if (is_dir($from)) {
                $this->copyDir($from, $to, $overwrite);
                continue;
            }
            if (is_file($from)) {
                if (!$overwrite && is_file($to)) continue;
                @mkdir(dirname($to), 0777, true);
                copy($from, $to);
            }
        }
    }
}
