<?php
namespace boru\boruaiweb\Support;

use boru\boruaiweb\Http\HtmlResponse;

class Renderer {
    private $resolver;

    public function __construct(PathResolver $resolver) {
        $this->resolver = $resolver;
    }

    /**
     * @param string $templateName e.g. 'webui.php'
     * @param array $vm ViewModel variables for the template
     */
    public function render($templateName, array $vm=array()) {
        $file = $this->resolver->resolveTemplate($templateName);
        if (!$file) {
            return new HtmlResponse('Template not found: ' . htmlspecialchars($templateName), 500);
        }

        $assets = $this->resolver; // convenience: $assets->assetUrl(...)
        ob_start();
        // Keep templates simple: they can use $vm or extracted variables.
        $vm = $vm;
        extract($vm, EXTR_SKIP);
        require $file;
        $html = ob_get_clean();
        return new HtmlResponse($html);
    }
}
