<?php
namespace boru\boruaiweb;

use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\Response;
use boru\boruaiweb\Http\Emitter;
use boru\boruaiweb\Routing\WebRouter;
use boru\boruaiweb\Publishing\Publisher;


class WebUI
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config)
    {
        $this->config = $config;
    }

    /**
     * Tiny entry point
     */
    public function render()
    {
        $req = Request::fromGlobals();
        $res = $this->handle($req);
        Emitter::emit($res);
    }

    /**
     * Testable entry point
     * @param Request $req
     * @return Response
     */
    public function handle(Request $req)
    {
        $router = new WebRouter($this->config);
        return $router->dispatch($req);
    }

    /**
     * Publish packaged defaults into user dirs (templates/assets)
     * (Implementation can come next; keep the signature stable now)
     */
    public function publishDefaults(array $options = array())
    {
        $overwrite = isset($options['overwrite']) ? (bool)$options['overwrite'] : false;

        $pkgRoot = dirname(__DIR__); // src → package root
        $resRoot = $pkgRoot . DIRECTORY_SEPARATOR . 'resources';

        // --- Publish assets ---
        if (!$this->config->publicDir) {
            throw new \RuntimeException('publicDir not configured; cannot publish assets');
        }

        $assetSrc = $resRoot . DIRECTORY_SEPARATOR . 'assets';
        $assetDst = $this->config->publicDir . DIRECTORY_SEPARATOR . 'assets';

        if (is_dir($assetSrc)) {
            Publisher::copyDir($assetSrc, $assetDst, $overwrite);
        }

        // --- Publish templates (optional override dir) ---
        if ($this->config->userTemplateDir) {
            $tplSrc = $resRoot . DIRECTORY_SEPARATOR . 'templates';
            $tplDst = $this->config->userTemplateDir;

            if (is_dir($tplSrc)) {
                Publisher::copyDir($tplSrc, $tplDst, $overwrite);
            }
        }

        return true;
    }

}
