<?php
namespace boru\boruaiweb\Actions;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\JsonResponse;

class HistoryActionController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config) { $this->config = $config; }

    public function handle(Request $req)
    {
        if (!$this->config->auth || !$this->config->history) {
            return JsonResponse::error(array(), 'History/auth services not configured', 500);
        }

        $user = $this->config->auth->currentUser();
        if (!$user) {
            return JsonResponse::error(array(), 'Not authenticated', 401);
        }

        $before = $req->param('before', null);
        $limit = (int)$req->param('limit', 10);
        $reference = (string)$req->param('reference', 'default');

        $historyUserId = $this->config->perUserReference ? $user->id() : null;

        $result = $this->config->history->playback($historyUserId, $reference, $limit, $before);
        if (is_array($result) && isset($result['output'])) {
            return JsonResponse::success($result);
        }

        return JsonResponse::error($result, 'No history found', 404);
    }
}
