<?php
namespace boru\boruaiweb\Actions;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\JsonResponse;

class ResponseActionController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config) { $this->config = $config; }

    public function handle(Request $req)
    {
        if (!$this->config->auth || !$this->config->responses) {
            return JsonResponse::error(array(), 'Response/auth services not configured', 500);
        }

        $user = $this->config->auth->currentUser();
        if (!$user) {
            return JsonResponse::error(array(), 'Not authenticated', 401);
        }

        $responseId = $req->param('responseId', null);
        if (!$responseId) {
            return JsonResponse::error(array(), 'No responseId provided', 400);
        }

        $row = $this->config->responses->find($responseId);
        if (!$row) {
            return JsonResponse::error(array('response_id' => $responseId), 'Response not found', 404);
        }

        return JsonResponse::success(array(
            'response_id' => isset($row['id']) ? $row['id'] : $responseId,
            'output' => isset($row['output']) ? $row['output'] : '',
            'status' => isset($row['status']) ? $row['status'] : null,
        ));
    }
}
