<?php
namespace boru\boruaiweb\Actions;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\JsonResponse;

class ToolActionController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config) { $this->config = $config; }

    public function handle(Request $req)
    {
        if (!$this->config->auth || !$this->config->tools) {
            return JsonResponse::error(array(), 'Tools/auth services not configured', 500);
        }

        $user = $this->config->auth->currentUser();
        if (!$user) {
            return JsonResponse::error(array(), 'Not authenticated', 401);
        }

        $mode = (string)$req->param('mode', '');
        if ($mode === '') {
            return JsonResponse::error(array(), 'No mode provided', 400);
        }

        if ($mode === 'list') {
            return JsonResponse::success(array('tools' => $this->config->tools->listTools()));
        }

        return JsonResponse::error(array(), 'Invalid mode', 400);
    }
}
