<?php
namespace boru\boruaiweb\Contracts;

use boru\boruaiweb\Domain\UserIdentity;

interface ChatServiceInterface
{
    /**
     * Stream chat events. $emit is called with a PHP array for each SSE chunk.
     *
     * @param UserIdentity $user
     * @param string $reference
     * @param string $message
     * @param array $options   (templateId, instructions, tools, etc.)
     * @param callable $emit   function(array $event): void
     * @return void
     */
    public function streamChat(UserIdentity $user, $reference, $message, array $options, $emit);
}
