<?php
namespace boru\boruaiweb\Http;

class ErrorResponse extends HtmlResponse
{
    /**
     * Backwards-compatible helper: simple message + optional details blob.
     *
     * @param int $status
     * @param string $title
     * @param string $messageText
     * @param string|null $detailsText
     * @return ErrorResponse
     */
    public static function html($status, $title, $messageText, $detailsText = null)
    {
        $sections = array(
            'Message' => (string)$messageText,
        );

        if ($detailsText !== null && $detailsText !== '') {
            $sections['Details'] = (string)$detailsText;
        }

        return self::sections($status, $title, $sections);
    }

    /**
     * Render a structured error page with readable sections.
     *
     * @param int $status
     * @param string $title
     * @param array $sections associative: sectionTitle => contentText
     * @return ErrorResponse
     */
    public static function sections($status, $title, array $sections)
    {
        $status = (int)$status;
        $titleEsc = htmlspecialchars((string)$title, ENT_QUOTES, 'UTF-8');

        $blocks = '';
        foreach ($sections as $sectionTitle => $content) {
            if ($content === null || $content === '') continue;

            $secTitleEsc = htmlspecialchars((string)$sectionTitle, ENT_QUOTES, 'UTF-8');
            $contentEsc = htmlspecialchars((string)$content, ENT_QUOTES, 'UTF-8');

            $blocks .=
                '<div class="section">'
              .   '<div class="section-title">' . $secTitleEsc . '</div>'
              .   '<pre class="section-body">' . $contentEsc . '</pre>'
              . '</div>';
        }

        $html =
'<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>' . $titleEsc . '</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;margin:0;background:#0b0f14;color:#e6edf3;}
    .wrap{max-width:980px;margin:48px auto;padding:0 18px;}
    .card{background:#111827;border:1px solid #1f2937;border-radius:12px;padding:18px;}
    h1{font-size:20px;margin:0 0 12px;}
    .status{display:inline-block;margin:6px 0 14px;font-size:12px;color:#93c5fd;}
    .section{margin-top:12px;border:1px solid #1f2937;border-radius:10px;overflow:hidden;}
    .section-title{background:#0b1220;padding:10px 12px;font-size:13px;color:#cbd5e1;border-bottom:1px solid #1f2937;}
    .section-body{margin:0;padding:12px;background:#0b0f14;color:#e6edf3;white-space:pre-wrap;word-break:break-word;font-size:12.5px;line-height:1.35;}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h1>' . $titleEsc . '</h1>
      <div class="status">HTTP ' . $status . '</div>
      ' . $blocks . '
    </div>
  </div>
</body>
</html>';

        return new self($status, array('Content-Type' => 'text/html; charset=UTF-8'), $html);
    }
}
