<?php
namespace boru\boruaiweb\Http;

class JsonResponse extends Response
{
    public static function ok(array $data, $status = 200)
    {
        $r = new self($status, array('Content-Type' => 'application/json'), $data);
        return $r;
    }

    public static function success($data, $status = 200)
    {
        return self::ok(array('success' => true, 'data' => $data), $status);
    }

    public static function error($data, $message = '', $status = 400)
    {
        $payload = array('success' => false, 'data' => $data);
        if ($message) $payload['error'] = $message;
        return self::ok($payload, $status);
    }
}
