<?php
namespace boru\boruaiweb\Pages;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\HtmlResponse;
use boru\boruaiweb\Assets\AssetManager;
use boru\boruaiweb\Rendering\PhpTemplateRenderer;

class DashboardPageController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config)
    {
        $this->config = $config;
    }

    public function handle(Request $req)
    {
        if ($this->config->auth) {
            $user = $this->config->auth->currentUser();
            if (!$user) {
                return new HtmlResponse(401, array('Content-Type' => 'text/plain; charset=UTF-8'), 'Not authenticated');
            }
        } else {
            $user = null;
        }

        $publicDir = $this->config->publicDir ? $this->config->publicDir : getcwd();
        $asset = new AssetManager($this->config->assetUrlPrefix, $publicDir);

        $renderer = new PhpTemplateRenderer(
            $this->config->userTemplateDir,
            $this->packageTemplateDir()
        );

        $reference = (string)$req->param('reference', 'default');
        $references = array();

        if ($this->config->references && $user) {
            $references = (array)$this->config->references->listForUser($user, 10);
            if (($req->param('reference', null) === null) && !empty($references)) {
                $reference = (string)$references[0];
            }
        }

        $instructionsHtml = '';

        $vm = array(
            'asset' => $asset,
            'user' => $user,
            'reference' => $reference,
            'references' => $references,
            'instructionsHtml' => $instructionsHtml,
        );

        $html = $renderer->render('webui.php', $vm);
        return HtmlResponse::ok($html);
    }

    private function packageTemplateDir()
    {
        $root = dirname(__DIR__); // .../src
        $pkgRoot = dirname($root); // package root
        return $pkgRoot . DIRECTORY_SEPARATOR . 'resources' . DIRECTORY_SEPARATOR . 'templates';
    }
}
