<?php
namespace boru\boruaiweb\Providers\BoruAI\History;

use boru\boruaiweb\Contracts\HistoryRepositoryInterface;
use boru\boruaiweb\Contracts\SettingsInterface;

class BoruAiHistoryRepository implements HistoryRepositoryInterface
{

    /** @var SettingsInterface|null */
    private $settings;

    /** @var string */
    private $settingsPrefix;

    /**
     * @param SettingsInterface|null $settings
     * @param string $settingsPrefix
     */
    public function __construct(SettingsInterface $settings = null, $settingsPrefix = 'boruaiweb.boruai.chat.')
    {
        $this->settings = $settings;
        $this->settingsPrefix = (string)$settingsPrefix;
    }

    private function get($key, $default = null)
    {
        if (!$this->settings) return $default;
        return $this->settings->get($this->settingsPrefix . $key, $default);
    }

    private function getBool($key, $default = false)
    {
        $v = $this->get($key, $default);
        return (bool)$v;
    }

    /**
     * @param int|string|null $userId
     * @param string $reference
     * @param int $limit
     * @param int|string|null $before
     * @return array
     */
    public function playback($userId, $reference, $limit, $before)
    {
        if (!class_exists('\\boru\\boruai\\Models\\ResponseHistory')) {
            return array();
        }

        $reference = (string)$reference;
        $limit = (int)$limit;

        // Legacy expects false when missing
        if ($before === null) $before = false;

        if($this->getBool("force_user_reference", false)) {
            if ($userId === null) {
                return array();
            }
            return \boru\boruai\Models\ResponseHistory::getPlayback($userId, $reference, $limit, $before);
        }
        return \boru\boruai\Models\ResponseHistory::getPlayback(null, $reference, $limit, $before);
    }
}
