<?php
namespace boru\boruaiweb\Providers\BoruAI\References;

use boru\boruai\BoruAI;
use boru\boruaiweb\Contracts\ReferenceRepositoryInterface;
use boru\boruaiweb\Contracts\SettingsInterface;
use boru\boruaiweb\Domain\UserIdentity;
use boru\boruaiweb\Domain\BoruAiUserIdentity;

class BoruAiReferenceRepository implements ReferenceRepositoryInterface
{
    /** @var bool */
    private $createIfMissing;

    /** @var SettingsInterface|null */
    private $settings;

    /** @var string */
    private $settingsPrefix;

    /**
     * @param SettingsInterface|null $settings
     * @param string $settingsPrefix
     */
    public function __construct(SettingsInterface $settings = null, $settingsPrefix = 'boruaiweb.boruai.references.')
    {
        $this->settings = $settings;
        $this->settingsPrefix = (string)$settingsPrefix;
        $this->createIfMissing = (bool)$this->get('create_if_missing', true);
    }

    private function get($key, $default = null)
    {
        if (!$this->settings) return $default;
        return $this->settings->get($this->settingsPrefix . $key, $default);
    }
    
    /**
     * @param UserIdentity $user
     * @param int $limit
     * @return string[]
     */
    public function listForUser(UserIdentity $user, $limit)
    {
        $limit = (int)$limit;

        // Best case: auth provider returned BoruAiUserIdentity carrying the real BoruAI user object
        if ($user instanceof UserIdentity) {
            $refs = static::forUser($user->id(), true, $limit);
            return is_array($refs) ? $refs : array();
        }

        // Last fallback: global references (if method exists)
        $refs = static::listReferences($limit);
        return is_array($refs) ? $refs : array();
    }

    private static $references = [];
    /**
     * 
     * @param bool $force 
     * @return array 
     * @throws Exception 
     */
    public static function forUser($userId,$force=false,$limit=10) {
        if(isset(self::$references[$userId]) && !$force) {
            return self::$references[$userId];
        }
        $table = BoruAI::table("responses");
        $sql = "select distinct `reference` from ".$table." where `reference` != '' and `user`=? order by `id` desc";
        if($limit) {
            $sql .= " limit " . intval($limit);
        }
        $db = BoruAI::db();
        $result = $db->query($sql, [$userId]);
        static::$references[$userId] = [];
        while($row = $db->next($result)) {
            static::$references[$userId][] = $row["reference"];
        }
        return static::$references[$userId];
    }

    public static function listReferences($limit=10) {
        $table = BoruAI::table("responses");
        $sql = "select distinct `reference` from ".$table." where `reference` != '' order by `id` desc";
        if($limit) {
            $sql .= " limit " . intval($limit);
        }
        $db = BoruAI::db();
        $result = $db->query($sql, []);
        $references = [];
        while($row = $db->next($result)) {
            $references[] = $row["reference"];
        }
        return $references;
    }
}
