<?php
namespace boru\boruaiweb\Rendering;

class PhpTemplateRenderer
{
    /** @var string|null */
    private $userTemplateDir; // base dir containing templates/custom + templates/default
    /** @var string */
    private $packageTemplateDir; // package resources/templates (source for publishing, not runtime)

    /**
     * @param string|null $userTemplateDir
     * @param string $packageTemplateDir
     */
    public function __construct($userTemplateDir, $packageTemplateDir)
    {
        $this->userTemplateDir = $userTemplateDir ? rtrim($userTemplateDir, DIRECTORY_SEPARATOR) : null;
        $this->packageTemplateDir = rtrim($packageTemplateDir, DIRECTORY_SEPARATOR);
    }

    /**
     * @param string $templateName e.g. "webui.php"
     * @param array $vars
     * @return string
     */
    public function render($templateName, array $vars)
    {
        $path = $this->resolve($templateName);
        if (!$path) {
            throw new \RuntimeException("Template not found: " . $templateName);
        }

        ob_start();
        $vm = $vars;
        extract($vars, EXTR_SKIP);
        require $path;
        return (string)ob_get_clean();
    }

    /**
     * custom first, default fallback
     *
     * @param string $templateName
     * @return string|null
     */
    public function resolve($templateName)
    {
        $templateName = ltrim((string)$templateName, '/\\');

        // User override structure:
        //   templates/custom/<name>
        //   templates/default/<name>
        if ($this->userTemplateDir) {
            $custom = $this->userTemplateDir . DIRECTORY_SEPARATOR . 'custom' . DIRECTORY_SEPARATOR . $templateName;
            if (is_file($custom)) return $custom;

            $default = $this->userTemplateDir . DIRECTORY_SEPARATOR . 'default' . DIRECTORY_SEPARATOR . $templateName;
            if (is_file($default)) return $default;
        }

        // As a safety net (if someone runs without publishing):
        // fallback to packaged resources/templates/<name>
        $pkg = $this->packageTemplateDir . DIRECTORY_SEPARATOR . $templateName;
        if (is_file($pkg)) return $pkg;

        return null;
    }
}
