<?php
namespace boru\boruaiweb\Routing;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\Response;
use boru\boruaiweb\Pages\DashboardPageController;

use boru\boruaiweb\Actions\ChatActionController;
use boru\boruaiweb\Actions\TemplateActionController;
use boru\boruaiweb\Actions\ToolActionController;
use boru\boruaiweb\Actions\HistoryActionController;
use boru\boruaiweb\Actions\ResponseActionController;

class WebRouter
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config) { $this->config = $config; }

    public function dispatch(Request $req)
    {
        // ACTIONS (AJAX / SSE)
        $action = $req->param($this->config->actionParam, null);
        if ($action) {
            $action = strtolower((string)$action);

            if ($action === 'chat') return (new ChatActionController($this->config))->handle($req);
            if ($action === 'template') return (new TemplateActionController($this->config))->handle($req);
            if ($action === 'tool') return (new ToolActionController($this->config))->handle($req);
            if ($action === 'history') return (new HistoryActionController($this->config))->handle($req);
            if ($action === 'response') return (new ResponseActionController($this->config))->handle($req);

            return new Response(
                404,
                array('Content-Type' => 'application/json'),
                json_encode(array('success'=>false,'error'=>'Invalid action'))
            );
        }

        // PAGES (HTML)
        $page = $req->param($this->config->pageParam, $this->config->defaultPage);
        $page = strtolower((string)$page);

        // For now: only dashboard, but this is where you add 2-3 more screens later.
        if ($page === 'dashboard') {
            return (new DashboardPageController($this->config))->handle($req);
        }

        return new Response(404, array('Content-Type'=>'text/plain; charset=UTF-8'), 'Page not found');
    }
}
