<?php
namespace boru\boruaiweb\Support;

class Arr {
    public static function get(array $arr, $path, $default=null) {
        if ($path === null || $path === '') return $arr;
        $parts = explode('.', $path);
        $cur = $arr;
        foreach ($parts as $p) {
            if (!is_array($cur) || !array_key_exists($p, $cur)) return $default;
            $cur = $cur[$p];
        }
        return $cur;
    }

    public static function set(array &$arr, $path, $value) {
        if ($path === null || $path === '') return;
        $parts = explode('.', $path);
        $cur =& $arr;
        foreach ($parts as $p) {
            if (!isset($cur[$p]) || !is_array($cur[$p])) $cur[$p] = array();
            $cur =& $cur[$p];
        }
        $cur = $value;
    }
}
