<?php
namespace boru\boruaiweb;

use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\Emitter;
use boru\boruaiweb\Http\ErrorResponse;
use boru\boruaiweb\Routing\WebRouter;
use boru\boruaiweb\Publishing\DefaultPublisher;

class WebUI
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config)
    {
        $this->config = $config;
    }

    public function render()
    {
        $req = null;

        try {
            $this->ensureDefaultsPublishedIfNeeded();

            $req = \boru\boruaiweb\Http\Request::fromGlobals();
            $res = $this->handle($req);

            \boru\boruaiweb\Http\Emitter::emit($res);
            return;
        } catch (\Exception $e) {
            $debug = (bool)$this->config->get('boruaiweb.debug', false);
            $res = \boru\boruaiweb\Http\ExceptionResponder::fromException($e, $req, $debug, $this->config);
            \boru\boruaiweb\Http\Emitter::emit($res);
            return;
        }

        // PHP 7+ only: catch Errors as well
        // (This block is unreachable in PHP 5.6 since Throwable doesn't exist there,
        // but including it in the file is fine because it's never parsed as a typehint.)
        if (class_exists('\\Throwable', false)) {
            try {
                // no-op, just to satisfy structure
            } catch (\Throwable $t) {
                $debug = (bool)$this->config->get('boruaiweb.debug', false);
                $res = \boru\boruaiweb\Http\ExceptionResponder::fromException($e, $req, $debug, $this->config);
                \boru\boruaiweb\Http\Emitter::emit($res);
                return;
            }
        }
    }


    public function handle(Request $req)
    {
        $router = new WebRouter($this->config);
        return $router->dispatch($req);
    }

    public function publishDefaults(array $options = array())
    {
        $overwrite = isset($options['overwrite']) ? (bool)$options['overwrite'] : false;
        $publisher = new DefaultPublisher($this->config);
        $publisher->publish($overwrite);
        return true;
    }

    private function ensureDefaultsPublishedIfNeeded()
    {
        $auto = (bool)$this->config->get('boruaiweb.publish.auto', true);
        if (!$auto) return;

        $publisher = new DefaultPublisher($this->config);
        if ($publisher->isPublished()) return;

        $publisher->publish(false);
    }
}
