<?php
namespace boru\boruelastic;

use boru\boruelastic\bulk\BulkEntry;
use boru\boruelastic\result\BulkResult;

class Bulk {

    /** @var Client */
    private $client;

    /** @var BulkEntry[] */
    private $bulkItems = [];
    private $itemCount = 0;
    private $onlyReturnErrors = false;

    public function __construct($client=null) {
        if(!is_null($client)) {
            $this->client($client);
        }
    }
    public function client($client=null) {
        if(is_null($client)) return $this->client;
        $this->client = $client;
    }

    public function run() {
        $this->assertClient();
        return new BulkResult($this->client->_bulk($this->bulkItems,$this->onlyReturnErrors,false),$this->itemCount);
    }
    public function onlyReturnErrors($onlyReturnErrors=true) {
        if(is_null($onlyReturnErrors)) return $this->onlyReturnErrors;
        $this->onlyReturnErrors = $onlyReturnErrors;
    }

    public function index($record) {
        $this->addHeaderItem("index",$record);
        $this->addBodyItem($record);
    }
    public function create($record) {
        $this->addHeaderItem("create",$record);
        $this->addBodyItem($record);
    }
    public function update($record) {
        $this->addHeaderItem("update",$record);
        $this->addBodyItem($record,true);
    }
    public function delete($record) {
        $this->addHeaderItem("delete",$record);
    }
    public function deleteById($index,$id) {
        $this->add(BulkEntry::fromArray(["delete"=>["_index"=>$index,"_id"=>$id]]));
    }

    public function add($bulkEntryItem) {
        $this->bulkItems[] = $bulkEntryItem;
    }

    private function addHeaderItem($action="index",$record) {
        $header = [];
        $header[$action] = ["_index"=>$record->index(),"_id"=>$record->id()];
        $this->add(BulkEntry::fromArray($header));
        $this->itemCount++;
        return $header;
    }
    private function addBodyItem($record,$isDoc=false) {
        $body = [];
        if($isDoc) {
            $body["doc"] = $record->get();
        } else {
            $body = $record->get();
        }
        $this->add(BulkEntry::fromArray($body));
        return $body;
    }

    private function assertClient() {
        if(is_null($this->client)) {
            $this->client = Elastic::client();
        }
        if(is_null($this->client)) {
            throw new \Exception("Bulk::run() called without a Client set");
        }
    }
}