<?php
namespace boru\boruelastic;

use boru\boruelastic\conn\Connector;

class Client extends Connector {
    public function indexExists($index) {
        try {
            $response = $this->headRequest($index,[],false);
        } catch (\Exception $e) {
            if($e->getCode() == 404) return false;
            throw $e;
        }
        return true;
    }
    public function templateExists($templateName) {
        $path = "_template/".$templateName;
        try {
            $response = $this->headRequest($path,[],false);
        } catch (\Exception $e) {
            if($e->getCode() == 404) return false;
            throw $e;
        }
        return true;
    }

    public function deleteById($index,$id,$async=null) {
        $path = $index."/_doc/".$id;
        return $this->deleteRequest($path,[],$async);
    }

    public function search($search, $index=null) {
        if(!($search instanceof Search)) throw new \Exception("search() expects a Search object");
        $search->client($this);
        return $search->run($index);
    }

    public function index($record) {
        if(!($record instanceof Record)) throw new \Exception("index() expects a Record object");
        $record->client($this);
        return $record->save();
    }

    public function delete($record) {
        if(!($record instanceof Record)) throw new \Exception("delete() expects a Record object");
        $record->client($this);
        return $record->delete();
    }
}