<?php
namespace boru\boruelastic\agg;

class FilterAgg extends BaseAgg {
    private $filter;
    public function __construct($filter=null,$aggs=null) {
        if(!is_null($filter)) {
            $this->filter($filter);
        }
        if(!is_null($aggs)) {
            $this->aggs($aggs);
        }
    }
    public function filter($filter) {
        $this->filter = $filter;
        return $this;
    }
    
    public function toArray() {
        $template = [
            "filter" => $this->filter,
        ];
        $subAggs = $this->getSubAggs();
        if(!empty($subAggs)) {
            $template["aggs"] = $subAggs;
        }
        return $template;
    }
    public function isEmpty() {
        return empty($this->filter) && empty($this->getSubAggs());
    }
}