<?php
namespace boru\boruelastic\agg;

class TopHitsAgg extends BaseAgg {
    public function __construct($size=null,$source=null,$sort=null) {
        $template = [
            "top_hits" => [
                "size" => null,
                "sort" => [],
                "_source" => []
            ]
        ];
        $this->set($template);
        if(!is_null($size)) {
            $this->size($size);
        }
        if(!is_null($source)) {
            $this->source($source);
        }
        if(!is_null($sort)) {
            $this->sort($sort);
        }
    }
    public function topHits($size=1,$source=null,$sort=null) {
        $this->size($size);
        if(!is_null($source)) {
            $this->source($source);
        }
        if(!is_null($sort)) {
            $this->sort($sort);
        }
    }
    public function size($size) {
        $this->set("top_hits.size",$size);
        return $this;
    }
    public function source($fields) {
        $current = $this->get("top_hits._source",[]);
        if(!is_array($current)) {
            $current = [$current];
        }
        if(!is_array($fields)) {
            $fields = [$fields];
        }
        $this->set("top_hits._source",array_merge($current,$fields));
        return $this;
    }
    public function sort($sort) {
        $current = $this->get("top_hits.sort",[]);
        if(!is_array($current)) {
            $current = [$current];
        }
        if(!is_array($sort)) {
            $sort = [$sort];
        }
        $this->set("top_hits.sort",array_merge($current,$sort));
        return $this;
    }

    public function toArray() {
        $data = ["top_hits"=>[]];
        $size = $this->get("top_hits.size");
        if(is_null($size) || $size<1) {
            $this->set("top_hits.size",1);
        }
        $data["top_hits"]["size"] = $this->get("top_hits.size");
        $sort = $this->get("top_hits.sort",[]);
        if(!empty($sort)) {
            $data["top_hits"]["sort"] = $sort;
        }
        $source = $this->get("top_hits._source",[]);
        if(!empty($source)) {
            $data["top_hits"]["_source"] = $source;
        }
        return $data;
    }

    public function isEmpty() {
        return false;
    }
}