<?php
namespace boru\boruelastic\query;

class MatchQuery extends BaseQuery {

    public function __construct($field,$values,$boost=null) {
        $this->match($field,$values);
        if(!is_null($boost)) {
            $this->boost($boost);
        }
    }

    public function match($field,$values) {
        $template = [
            "match" => [
                $field => $values
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function boost($value) {
        $this->set("match.boost",$value);
        return $this;
    }
}