<?php
namespace boru\boruelastic\result;

class Hit extends BaseResult {
    private $index;
    private $id;
    private $score;
    private $fields;
    private $source;

    /** @var Hits[] */
    private $innerHits;

    private $fullArray = [];

    public function __construct($data) {
        $this->fullArray = $data;
        $this->index = $data["_index"];
        $this->id = $data["_id"];
        $this->score = $data["_score"];
        unset($data["_index"]);
        unset($data["_id"]);
        unset($data["_score"]);
        if(isset($data["_source"])) {
            $this->source = $data["_source"];
            unset($data["_source"]);
        }
        if(isset($data["fields"])) {
            $this->fields = $data["fields"];
            unset($data["fields"]);
        }
        if(isset($data["inner_hits"])) {
            $this->parseInnerHits($data["inner_hits"]);
            unset($data["inner_hits"]);
        }
        $useData = $data;
        if(!is_null($this->fields)) {
            $useData = $this->fields;
        } elseif(!is_null($this->source)) {
            $useData = $this->source;
        }
        $this->set(BaseResult::shorten($useData));
    }

    public function index() {
        return $this->index;
    }
    public function id() {
        return $this->id;
    }
    public function score() {
        return $this->score;
    }
    public function innerHits() {
        return $this->innerHits;
    }
    public function source() {
        return $this->source;
    }
    public function fields() {
        return $this->fields;
    }
    public function toArray($raw=false) {
        if($raw) {
            return $this->fullArray;
        }
        $data["_index"] = $this->index();
        $data["_id"] = $this->id();
        $data["_score"] = $this->score();
        $data = array_merge($data,parent::toArray());
        return $data;
    }

    private function parseInnerHits($innerHits) {
        foreach($innerHits as $name=>$hitsJson) {
            $this->innerHits[$name] = new Hits($hitsJson);
        }
    }
}