<?php

use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\ConfigFile;

require __DIR__."/../vendor/autoload.php";

$configCreate = false;
if(!file_exists(__DIR__."/config.json")) {
    echo "Config file not found. Creating... with default content, you'll need to edit it manually with your own values..\n\n\n";
    $configCreate = true;
}
$config = new ConfigFile(["path"=>__DIR__."/config.json",["prettyJson"=>true,"sort"=>true]]);
$config->load();
if($config->get("endpoint",false) === false) {
    $config->set("endpoint","http://localhost:9200");
    $config->save();
}
if($config->get("auth",false) === false) {
    $config->set("auth",["username"=>"elastic","password"=>"changeme"]);
    $config->save();
}
if($configCreate) {
    echo "Config file created. Please edit it with your own values.\nCurrent defaults:\n";
    echo "Endpoint: ".$config->get("endpoint")."\n";
    echo "Auth: ".json_encode($config->get("auth"))."\n";
    echo "\n\n";
    echo "Raw file:\n";
    echo file_get_contents(__DIR__."/config.json");
    echo "\n\n";
}