<?php
namespace boru\boruelastic;

use boru\boruelastic\query\BoolQuery;
use boru\boruelastic\query\ExistsQuery;
use boru\boruelastic\query\IdsQuery;
use boru\boruelastic\query\MatchPhrasePrefixQuery;
use boru\boruelastic\query\MatchPhraseQuery;
use boru\boruelastic\query\MatchQuery;
use boru\boruelastic\query\RangeQuery;
use boru\boruelastic\query\TermQuery;
use boru\boruelastic\query\TermsQuery;

class Query extends BoolQuery {

    public function __construct() {
        
    }

    public function toArray() {
        return parent::toArray();
    }
    public function __toString() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT);
    }
    public function jsonSerialize() {
        return $this->toArray();
    }

    public static function bool($must=[],$mustNot=[],$should=[],$minimumShould=1) {
        $bool = new BoolQuery("bool");
        if(!empty($must)) {
            foreach($must as $q) {
                $bool->must($q);
            }
        }
        if(!empty($mustNot)) {
            foreach($mustNot as $q) {
                $bool->mustNot($q);
            }
        }
        if(!empty($should)) {
            foreach($should as $q) {
                $bool->should($q);
            }
        }
        $bool->minimumShould($minimumShould);
        return $bool;
    }
    public static function exists($field) {
        return new ExistsQuery($field);
    }
    public static function match($field,$value,$boost=null) {
        return new MatchQuery($field,$value,$boost);
    }
    public static function ids($field,$value,$boost=null) {
        return new IdsQuery($field,$value,$boost);
    }
    public static function matchPhrase($field,$value,$boost=null) {
        return new MatchPhraseQuery($field,$value,$boost);
    }
    public static function matchPhrasePrefix($field,$value,$boost=null) {
        return new MatchPhrasePrefixQuery($field,$value,$boost);
    }
    public static function range($field,$comparator,$value) {
        return new RangeQuery($field,$comparator,$value);
    }
    public static function term($field,$value,$boost=null) {
        return new TermQuery($field,$value,$boost);
    }
    public static function terms($field,$values,$boost=null) {
        return new TermsQuery($field,$values,$boost);
    }
    public static function instance() {
        return new static();
    }
}