<?php
namespace boru\boruelastic\query;

class BoolQuery extends BaseQuery {
    public function __construct() {
        $template = [
            "bool" => [
                "must" => [],
                "should" => [],
                "must_not" => [],
                "minimum_should_match" => 1
            ]
        ];
        $this->set($template);
    }

    public function must($query) {
        if($query !== false && !is_null($query)) {
            $must = $this->get("bool.must");
            $must[] = $query;
            $this->set("bool.must",$must);
        }
        return $this;
    }
    public function should($query) {
        if($query !== false && !is_null($query)) {
            $should = $this->get("bool.should");
            $should[] = $query;
            $this->set("bool.should",$should);
        }
        return $this;
    }
    public function mustNot($query) {
        if($query !== false && !is_null($query)) {
            $must_not = $this->get("bool.must_not");
            $must_not[] = $query;
            $this->set("bool.must_not",$must_not);
        }
        return $this;
    }
    public function minimumShould($num=1) {
        $this->set("bool.minimum_should_match",$num);
        return $this;
    }

    public function toArray() {
        $data = $this->get("bool");
        if(empty($data["must"])) {
            unset($data["must"]);
        }
        if(empty($data["should"])) {
            unset($data["should"]);
            unset($data["minimum_should_match"]);
        }
        if(empty($data["must_not"])) {
            unset($data["must_not"]);
        }
        return ["bool"=>$data];
    }

    public function isEmpty() {
        return empty($this->get("bool.must")) && empty($this->get("bool.should")) && empty($this->get("bool.must_not"));
    }
}