<?php
namespace boru\boruelastic\query;

class MatchPhrasePrefixQuery extends BaseQuery {

    public function __construct($field,$values,$boost=null) {
        $this->match($field,$values);
        if(!is_null($boost)) {
            $this->boost($boost);
        }
    }

    public function match($field,$values) {
        $template = [
            "match_phrase_prefix" => [
                $field => $values
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function boost($value) {
        $this->set("match_phrase_prefix.boost",$value);
        return $this;
    }
    public function analyzer($value) {
        $this->set("match_phrase_prefix.analyzer",$value);
        return $this;
    }
}