<?php
namespace boru\boruelastic\result;

use boru\boruelastic\type\BaseType;

class BaseResult extends BaseType {
    public function __construct($data) {
        $this->set($data);
    }
    public function toArray() {
        return $this->get();
    }

    public function get($key=null,$default=NULL) {
        $value = parent::get($key,$default);
        if(is_array($value)) {
            if(isset($value["hits"]) && isset($value["hits"]["hits"])) {
                return new Hits($value);
            }
            if(isset($value["buckets"]) && isset($value["buckets"][0])) {
                $s = explode(".",$key);
                $name = end($s);
                return new Aggregation($name,$value);
            }
            if(count($value) == 1 && isset($value["value"])) {
                return $value["value"];
            }
        }
        return $value;
    }

    public static function shorten($array) {
        static::_shorten($array);
        return $array;
    }
    private static function _shorten(&$array) {
        if(count($array) == 1 && is_array(array_values($array)[0])) {
            $array = array_values($array)[0];
            static::_shorten($array);
        }
    }
}