<?php
namespace boru\boruelastic\result;

class Bucket extends BaseResult {
    private $key;
    private $docCount;
    public function __construct($data) {
        $this->key = $data["key"];
        $this->docCount = $data["doc_count"];
        unset($data["key"]);
        unset($data["doc_count"]);
        if(count($data) == 1 && isset(array_values($data)[0]["value"])) {
            $data = ["value"=>array_values($data)[0]["value"]];
        } else {
            foreach($data as $name=>$value) {
                if(is_array($value) && isset($value["value"])) {
                    $data[$name] = $value["value"];
                }
            }
        }
        $this->set($data);
    }
    public function key() {
        return $this->key;
    }
    public function docCount() {
        return $this->docCount;
    }
    public function toArray() {
        $data["key"] = $this->key();
        $data["doc_count"] = $this->docCount();
        $parent = $this->get();
        if(is_array($parent)) {
            $data = array_merge($data,$parent);
        } else {
            $data["value"] = $parent;
        }
        return $data;
    }
}