<?php
namespace boru\boruelastic\result;

use boru\boruelastic\type\ArrayIterator;

class BulkResult extends ArrayIterator  {
    private $took;
    private $totalSent = 0;
    private $errors = false;
    public function __construct($resultData,$numRequests=null) {
        if(!empty($resultData)) {
            $this->loadResults($resultData);
        }
        if(!is_null($numRequests)) {
            $this->totalSent = $numRequests;
        }
    }

    public function loadResults($resultData,$numRequests=null) {
        $this->took = $resultData["took"];
        $this->errors = $resultData["errors"] ? true : false;
        if(isset($resultData["items"])) {
            $this->setIteratorArray($resultData["items"]);
            unset($resultData["items"]);
        }
        $this->set($resultData);
        if(!is_null($numRequests)) {
            $this->totalSent = $numRequests;
        }
    }

    public function took() {
        return $this->took;
    }
    public function totalSent() {
        return $this->totalSent;
    }
    public function total() {
        return count($this->getAll());
    }
    public function errors() {
        return $this->errors;
    }
    /**
     * @return ResultItem[]
     */
    public function items() {
        return $this->getAll();
    }
    /**
     * @param int $i
     * @return ResultItem 
     */
    public function item($i) {
        return $this->getAt($i);
    }
    /**
     * @return ResultItem 
     */
    public function nextItem() {
        return $this->next();
    }

    public function toArray() {
        $data = parent::toArray();
        $data["items"] = $this->getAll();
        return $data;
    }

    public function transformIteratorValue($value) {
        if($value instanceof ResultItem) {
            return $value;
        }
        return new ResultItem($value);
    }
}