<?php
namespace boru\boruelastic\result;

use boru\boruelastic\type\ArrayIterator;

class Hits extends ArrayIterator {
    private $total;
    private $maxScore;
    public function __construct($data) {
        $this->setIteratorArray($data["hits"]);
        unset($data["hits"]);
        $this->set($data);
        $this->total = $this->get("total");
        $this->maxScore = $this->get("max_score",null);
        
    }
    public function total() {
        return $this->total;
    }
    public function maxScore() {
        return $this->maxScore;
    }
    public function hits() {
        return $this->getAll();
    }

    public function hit($i) {
        return $this->getAt($i);
    }

    /**
     * @return Hit 
     */
    public function nextHit() {
        return $this->next();
    }
    
    public function toArray() {
        $data = parent::toArray();
        $data["hits"] = $this->getAll();
        return $data;
    }

    public function transformIteratorValue($value) {
        if($value instanceof Hit) {
            return $value;
        }
        return new Hit($value);
    }
}