<?php
namespace boru\boruelastic\type;

use boru\dhutils\dhGlobal;

class BaseType implements \JsonSerializable {
    private $data;

    public function get($key=null,$default=NULL) {
        if(is_null($key)) {
            return $this->data;
        }
        return dhGlobal::getVal($this->data,$key,$default,".");
    }
    public function set($key,$value=null) {
        if(is_array($key)) {
            $this->data = $key;
            return $this;
        }
        if(strpos($key,".")===false) {
            $this->data[$key] = $value;
            return $this;
        }
        dhGlobal::dotAssign($this->data,$key,$value,".");
        return $this;
    }

    public function toArray() {
        return $this->data;
    }
    public function toJson() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
    }

    public function __toString() {
        return $this->toJson();
    }
    public function jsonSerialize() {
        return $this->toArray();
    }

    public static function instance() {
        return new static();
    }
}