<?php

use boru\boruelastic\Bulk;
use boru\boruelastic\Record;

require __DIR__."/Client.php";

$testJohn = Record::fromArray(
    [
        "first_name"=>"John",
        "last_name"=>"Doe",
        "age"=>30,
        "about"=>"I love to go rock climbing",
        "interests"=>[
            "sports",
            "music"
        ]
    ]
)->index("boru_test")->id("john_doe_test_1");
$testJane = Record::fromArray(
    [
        "first_name"=>"Jane",
        "last_name"=>"Doe",
        "age"=>25,
        "about"=>"I love to go rock climbing",
        "interests"=>[
            "sports",
            "music"
        ]
    ]
)->index("boru_test")->id("jane_doe_test_1");

$bulk = new Bulk();
$bulk->index($testJohn);
$bulk->index($testJane);
$result = $bulk->run();
echo "Sent ".$result->totalSent()." requests\n";
echo "Received ".$result->total()." responses\n";
foreach($result as $bulkResult) {
    echo $bulkResult."\n";
}
