<?php
namespace boru\boruelastic;

use boru\boruelastic\Client;
use Exception;

class Elastic {
    private static $client;
    public static function init($endpoint,$options=[]) {
        static::$client = new Client($endpoint,$options);
    }
    public static function endpoint($endpoint=null) {
        static::assertInit();
        if(is_null($endpoint)) return static::$client->endpoint();
        static::$client->endpoint($endpoint);
    }
    public static function auth($auth=null) {
        static::assertInit();
        if(is_null($auth)) return static::$client->auth();
        static::$client->auth($auth);
    }
    public static function async($async=null) {
        static::assertInit();
        if(is_null($async)) return static::$client->async();
        static::$client->async($async);
    }
    public static function client() {
        static::assertInit();
        return static::$client;
    }
    public static function setClient($connector,$overwrite=false) {
        if(is_null(static::$client) || $overwrite) {
            static::$client = $connector;
        }
    }
    public static function indexExists($index) {
        static::assertInit();
        return static::$client->indexExists($index);
    }
    public static function templateExists($templateName) {
        static::assertInit();
        return static::$client->templateExists($templateName);
    }
    /**
     * @param Search $search 
     * @param string|null $index 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public static function search($search,$index=null) {
        static::assertInit();
        return static::$client->search($search,$index);
    }
    /**
     * @param Record $record 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public static function index($record) {
        static::assertInit();
        return static::$client->index($record);
    }
    /**
     * @param Record $record 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public static function delete($record) {
        static::assertInit();
        return static::$client->delete($record);
    }
    /**
     * @param string $index 
     * @param string $id 
     * @param bool|null $async 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public static function deleteById($index,$id,$async=null) {
        static::assertInit();
        return static::$client->deleteById($index,$id,$async);
    }

    private static function assertInit() {
        if(is_null(static::$client)) throw new \Exception("Elastic::init() must be called before using Elastic");
    }
}