<?php
namespace boru\boruelastic;

use boru\boruelastic\result\Results;
use boru\boruelastic\type\BaseType;
use boru\boruelastic\type\SortType;

class Search extends BaseType {
    private $index;

    /** @var Client */
    private $client;

    /** @var Query */
    private $query;
    /** @var Aggs */
    private $aggs;
    /** @var SortType */
    private $sort;
    /** @var array */
    private $fields;

    private $collapse;
    /** @var bool */
    private $source=true;
    /** @var int */
    private $size=1000;

    /*public function __construct($endpoint,$auth=null) {
        $this->endpoint($endpoint);
        $this->auth($auth);
    }*/
    public function __construct($client=null) {
        if(!is_null($client)) {
            $this->client($client);
        }
    }
    public function client($client=null) {
        if(is_null($client)) return $this->client;
        $this->client = $client;
    }

    public function index($index=null) {
        if(is_null($index)) return $this->index;
        $this->index = $index;
    }

    public function source($source=true) {
        $this->source=$source ? true : false;
        return $this;
    }
    public function size($size=1000) {
        $this->size= (int) $size;
        return $this;
    }
    public function query($query) {
        $this->query = $query;
        return $this;
    }
    public function aggs($aggs) {
        if($aggs instanceof Aggs) {
            $this->aggs = $aggs;
        } else {
            throw new \Exception("aggs must be an instance of Aggs");
        }
        $this->aggs = $aggs;
        return $this;
    }
    public function fields($fields) {
        $this->fields = $fields;
        return $this;
    }
    public function collapse($collapse) {
        $this->collapse = $collapse;
        return $this;
    }

    //convinience functions
    public function addAgg($name,$agg) {
        if(is_null($this->aggs)) {
            $this->aggs = new Aggs();
        }
        $this->aggs->add($name,$agg);
    }
    public function must($must) {
        if(is_null($this->query)) {
            $this->query = new Query();
        }
        $this->query->must($must);
        return $this;
    }
    public function mustNot($mustNot) {
        if(is_null($this->query)) {
            $this->query = new Query();
        }
        $this->query->mustNot($mustNot);
        return $this;
    }
    public function should($should) {
        if(is_null($this->query)) {
            $this->query = new Query();
        }
        $this->query->should($should);
        return $this;
    }
    public function minimumShould($minimumShouldMatch) {
        if(is_null($this->query)) {
            $this->query = new Query();
        }
        $this->query->minimumShould($minimumShouldMatch);
        return $this;
    }
    public function sort($sortType) {
        $this->sort = $sortType;
        return $this;
    }

    public function toArray() {
        $query = [];
        if(!is_null($this->query)) {
            $query['query'] = $this->query;
        }
        if(!is_null($this->aggs)) {
            $query['aggs'] = $this->aggs;
        }
        if(!is_null($this->fields)) {
            $query['fields'] = $this->fields;
        }
        if(!is_null($this->collapse)) {
            $query['collapse'] = $this->collapse;
        }
        if(!is_null($this->source)) {
            $query['_source'] = $this->source;
        }
        if(!is_null($this->sort)) {
            $query['sort'] = $this->sort;
        }
        if(!is_null($this->size)) {
            $query['size'] = $this->size;
        }
        return $query;
    }

    public function run($index="") {
        $this->assertClient();
        if(!empty($index)) {
            $this->index($index);
        }
        if($this->client->async()) {
            $deferred = new \React\Promise\Deferred();
            $this->client->getRequest($this->index."/_search",$this->toArray())->then(function($results) use ($deferred) {
                $deferred->resolve(new Results($results));
            },function($error) use ($deferred) {
                $deferred->reject($error);
            });
            return $deferred->promise();
        }
        return new Results($this->client->getRequest($this->index."/_search",$this->toArray()));
    }

    private function assertClient() {
        if(is_null($this->client)) {
            $this->client = Elastic::client();
        }
        if(is_null($this->client)) {
            throw new \Exception("Search::run() called without a Client set");
        }
    }
}