<?php
namespace boru\boruelastic\query;

class MatchPhraseQuery extends BaseQuery {

    public function __construct($field,$values,$boost=null) {
        $this->match($field,$values);
        if(!is_null($boost)) {
            $this->boost($boost);
        }
    }

    public function match($field,$values) {
        $template = [
            "match_phrase" => [
                $field => $values
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function boost($value) {
        $this->set("match_phrase.boost",$value);
        return $this;
    }
    public function analyzer($value) {
        $this->set("match_phrase.analyzer",$value);
        return $this;
    }
}