<?php
namespace boru\boruelastic\query;

class TermQuery extends BaseQuery {

    public function __construct($field,$values,$boost=null) {
        $this->term($field,$values);
        if(!is_null($boost)) {
            $this->boost($boost);
        }
    }

    public function term($field,$values) {
        $template = [
            "term" => [
                $field => $values
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function boost($value) {
        $this->set("term.boost",$value);
        return $this;
    }
}