<?php
namespace boru\boruelastic\result;

use boru\boruelastic\type\ArrayIterator;

class BulkResult extends ArrayIterator  {
    private $took = 0;
    private $totalSent = 0;
    private $errors = false;
    private $errorMessage = false;
    public function __construct($resultData,$numRequests=null) {
        if(!empty($resultData)) {
            $this->loadResults($resultData);
        }
        if(!is_null($numRequests)) {
            $this->totalSent = $numRequests;
        }
    }

    public function loadResults($resultData,$numRequests=null) {
        $this->took = isset($resultData["took"]) ? $resultData["took"] : 0;
        if(isset($resultData["errors"])) {
            $this->errors = $resultData["errors"] ? true : false;
        }
        if(isset($resultData["items"])) {
            $this->setIteratorArray($resultData["items"]);
            unset($resultData["items"]);
        }
        if(isset($resultData["error"])) {
            $this->errorMessage = $resultData["error"];
        }
        $this->set($resultData);
        if(!is_null($numRequests)) {
            $this->totalSent = $numRequests;
        }
    }

    /**
     * @return int
     */
    public function took() {
        return $this->took;
    }
    /**
     * @return int
     */
    public function totalSent() {
        return $this->totalSent;
    }
    /**
     * @return int
     */
    public function total() {
        $arr = $this->getAll();
        return is_array($arr) ? count($arr) : 0;
    }
    /**
     * @return bool
     */
    public function errors() {
        return $this->errors;
    }
    /**
     * @return false|mixed
     */
    public function errorMessage() {
        return $this->errorMessage;
    }
    /**
     * @return ResultItem[]
     */
    public function items() {
        return $this->getAll();
    }
    /**
     * @param int $i
     * @return ResultItem 
     */
    public function item($i) {
        return $this->getAt($i);
    }
    /**
     * @return ResultItem 
     */
    public function nextItem() {
        return $this->next();
    }

    /**
     * @return array 
     */
    public function toArray() {
        $data = parent::toArray();
        $data["items"] = $this->getAll();
        return $data;
    }

    /**
     * @param mixed $value
     * @return ResultItem 
     */
    public function transformIteratorValue($value) {
        if($value instanceof ResultItem) {
            return $value;
        }
        return new ResultItem($value);
    }
}