<?php
namespace boru\boruelastic\result;

class ResultItem extends BaseResult {
    private $action;
    private $index;
    private $id;
    private $version;
    private $result;
    private $shards;
    private $status;
    private $seqNo;
    private $primaryTerm;
    private $error;

    public function __construct($data) {
        if(!isset($data["_index"]) && !isset($data["error"])) {
            $oData = $data;
            $action = array_keys($data)[0];
            $data = $data[$action];
            $this->action = $action;
            if(!isset($data["_index"])) {
                print_r($oData);
                print_r($data);
                throw new \Exception("Invalid data for ResultItem ");
            }
        }
        
        if(isset($data["_index"]))          { $this->index = $data["_index"]; }
        if(isset($data["_id"]))             { $this->id = $data["_id"]; }
        if(isset($data["_version"]))        { $this->version = $data["_version"]; }
        if(isset($data["result"]))          { $this->result = $data["result"]; }
        if(isset($data["_shards"]))         { $this->shards = new Shards($data["_shards"]); }
        if(isset($data["status"]))          { $this->status = $data["status"]; }
        if(isset($data["_seq_no"]))         { $this->seqNo = $data["_seq_no"]; }
        if(isset($data["_primary_term"]))   { $this->primaryTerm = $data["_primary_term"]; }
        if(isset($data["error"]))           { $this->error = $data["error"]; }

        $this->set($data);
    }

    public function action() {
        return $this->action;
    }
    public function index() {
        return $this->index;
    }
    public function id() {
        return $this->id;
    }
    public function version() {
        return $this->version;
    }
    public function result() {
        return $this->result;
    }
    public function shards() {
        return $this->shards;
    }
    public function status() {
        return $this->status;
    }
    public function seqNo() {
        return $this->seqNo;
    }
    public function primaryTerm() {
        return $this->primaryTerm;
    }
    public function error() {
        return $this->error;
    }
}