<?php
namespace boru\boruelastic\result;

use boru\boruelastic\result\BaseResult;

class Results extends BaseResult {
    private $took;
    private $timedOut;
    private $shards;
    private $hits;
    private $aggregations;

    public function __construct($resultData=[]) {
        if(!empty($resultData)) {
            $this->loadResults($resultData);
        }
    }

    public function loadResults($resultData) {
        $this->took = $resultData["took"];
        $this->timedOut = $resultData["timed_out"];
        $this->shards = new Shards($resultData["_shards"]);
        $this->hits = new Hits($resultData["hits"]);
        unset($resultData["took"]);
        unset($resultData["timed_out"]);
        unset($resultData["_shards"]);
        unset($resultData["hits"]);
        if(isset($resultData["aggregations"])) {
            foreach($resultData["aggregations"] as $name => $aggregation) {
                $this->aggregations[$name] = new Aggregation($name,$aggregation);
            }
            unset($resultData["aggregations"]);
        }
        $this->set($resultData);
    }

    public function took() {
        return $this->took;
    }
    /**
     * Use in Search results to determine if the search timed out
     * @return bool 
     */
    public function timedOut() {
        return $this->timedOut ? true : false;
    }
    public function shards() {
        return $this->shards;
    }
    public function hits() {
        return $this->hits;
    }
    public function aggregations() {
        return $this->aggregations;
    }
    /**
     * @param string $name
     * @return Aggregation|bool
     */
    public function aggregation($name) {
        if(isset($this->aggregations[$name])) {
            return $this->aggregations[$name];
        }
        return false;
    }
}