<?php
namespace boru\boruelastic\type;

use boru\boruelastic\type\BaseType;

class ArrayIterator extends BaseType implements \Iterator {

    private $arr;
    /**
     * We're setting this to -1 so that the first call to next() will return the first value, unless current() is called first
     * If current() is called first, then next() will return the second value
     * @var int
     */
    private $pos = -1;
    public function setIteratorArray($arr) {
        $this->arr = $arr;
    }
    public function rewind() {
        return reset($this->arr);
    }
    public function current() {
        if($this->pos == -1) {
            $this->pos = 0;
        }
        $value = current($this->arr);
        if($value) {
            return $this->transformIteratorValue($value);
        }
        return false;
    }
    public function key() {
        return key($this->arr);
    }
    public function next() {
        if($this->pos == -1) {
            $returnValue = $this->current();
        } else {
            $returnValue = next($this->arr);
        }
        if($returnValue) {
            return $this->transformIteratorValue($returnValue);
        }
        return false;
    }
    public function valid() {
        return key($this->arr) !== null;
    }
    public function getAll() {
        return $this->arr;
    }
    public function getAt($i) {
        if(isset($this->arr[$i])) {
            return $this->transformIteratorValue($this->arr[$i]);
        }
        return false;
    }
    public function transformIteratorValue($value) {
        return $value;
    }
}