<?php

use boru\boruelastic\ElasticClient;
use boru\boruelastic\Query;
use boru\boruelastic\Search;

require __DIR__."/init.php";


//Static (prefered) configuration:
//Elastic::init($config->get("endpoint"),["auth"=>$config->get("auth")]);
$elastic = new ElasticClient($config->get("endpoint"),["auth"=>$config->get("auth")]);

$search = new Search($elastic);
$search->index("boru_test");
$search->must(Query::match("first_name","Jane"));
$search->source(true)->size(3);
$result = $search->run();
print_r($result);
foreach($result->hits() as $hit) {
    echo "Hit with score of ".$hit->score()." :: ID: ".$hit->id().", FirstName: ".$hit->get("first_name")."\n";
}