<?php
namespace boru\boruelastic;

use boru\boruelastic\filter\BaseFilter;
use boru\boruelastic\filter\RangeFilter;
use boru\boruelastic\filter\TermFilter;

class Filter extends BaseFilter {
    private $filters;
    public function __construct() {
    }

    public function toArray() {
        $data = [];
        foreach($this->filters as $part) {
            if(!$part->isEmpty()) {
                $data[] = $part;
            }
        }
        return ["filter"=>$data];
    }

    public function add($name,$filter) {
        $this->filters[$name] = $filter;
    }

    public static function term($field,$value) {
        return new TermFilter($field,$value);
    }
    public static function range($field,$comparator,$value) {
        return new RangeFilter($field,$comparator,$value);
    }
    public static function instance() {
        return new static();
    }
}