<?php
namespace boru\boruelastic;

use boru\boruelastic\result\ResultItem;
use boru\boruelastic\type\BaseType;

class Record extends BaseType {
    /** @var ElasticClient */
    private $client;

    public function __construct($data=null,$client=null) {
        if(!is_null($client)) {
            $this->client($client);
        }
        if(!is_null($data)) {
            $this->setRaw($data);
        }
    }
    public function client($client=null) {
        if(is_null($client)) return $this->client;
        $this->client = $client;
    }

    public function id($id=null) {
        if(is_null($id)) return $this->getRaw("_id",false);
        $this->setRaw("_id",$id);
        return $this;
    }
    public function index($index=null) {
        if(is_null($index)) return $this->getRaw("_index",false);
        $this->setRaw("_index",$index);
        return $this;
    }
    public function type($type=null) {
        if(is_null($type)) return $this->getRaw("_type",false);
        $this->setRaw("_type",$type);
        return $this;
    }
    public function version($version=null) {
        if(is_null($version)) return $this->getRaw("_version",false);
        $this->setRaw("_version",$version);
        return $this;
    }
    public function seqNo($seqNo=null) {
        if(is_null($seqNo)) return $this->getRaw("_seq_no",false);
        $this->setRaw("_seq_no",$seqNo);
        return $this;
    }
    public function primaryTerm($primaryTerm=null) {
        if(is_null($primaryTerm)) return $this->getRaw("_primary_term",false);
        $this->setRaw("_primary_term",$primaryTerm);
        return $this;
    }
    public function found($found=null) {
        if(is_null($found)) return $this->getRaw("found",false);
        $this->setRaw("found",$found);
        return $this;
    }
    public function source($source=null) {
        if(is_null($source)) return $this->getRaw("_source",false);
        $this->setRaw("_source",$source);
        return $this;
    }

    public function getRaw($key,$default=null) {
        return parent::get($key,$default);
    }
    public function get($key=null,$default=NULL) {
        if(is_null($key)) {
            return parent::get("_source");
        }
        return parent::get("_source.".$key,$default);
    }
    public function setRaw($key,$value=null) {
        return parent::set($key,$value);
    }
    public function set($key,$value=null) {
        if(is_array($key)) {
            return parent::set($key);
        }
        return parent::set("_source.".$key,$value);
    }

    public function save() {
        $this->assertClient();
        if($this->id()) {
            $path = $this->index()."/_doc/".$this->id();
            $result = new ResultItem($this->client->putRequest($path,$this->source()));
        } else {
            $path = $this->index()."/_doc";
            $result = new ResultItem($this->client->postRequest($path,$this->source()));
        }
        if($result->id()) {
            $this->id($result->id());
        }
        if($result->version()) {
            $this->version($result->version());
        }
        if($result->index()) {
            $this->index($result->index());
        }
        return $result;
    }
    public function delete() {
        $this->assertClient();
        if($this->id()) {
            $path = $this->index()."/_doc/".$this->id();
            $this->client->deleteRequest($path);
        }
    }
    public function load($id,$index) {
        $this->assertClient();
        $path = $index."/_doc/".$id;
        $response = $this->client->getRequest($path);
        $this->setRaw($response);
        return $this;
    }

    public static function fromId($id,$index,$client=null) {
        $record = new Record(null,$client);
        $record->load($id,$index);
        return $record;
    }
    public static function fromArray($data,$id=null,$client=null) {
        $record = new Record(null,$client);
        $record->source($data);
        if(!is_null($id)) {
            $record->id($id);
        }
        return $record;
    }

    private function assertClient() {
        if(is_null($this->client)) {
            $this->client = Elastic::client();
        }
        if(is_null($this->client)) {
            throw new \Exception("Record::save() and Record::delete() cannot be called without a Client.");
        }
    }
}